package gov.va.vinci.dart.db;

import java.util.List;

import gov.va.vinci.dart.biz.GroupTask;

public interface GroupTaskDAO {

	void save(final GroupTask groupTask);
	void delete(final GroupTask groupTask);
	GroupTask findById(final int taskId);
	List<GroupTask> listByOwner(final int ownerId);
	List<GroupTask> listOpenByOwner(final int ownerId);
	List<GroupTask> listOpenByOwnerAndRequestId(final int ownerId, final int requestId);
	List<GroupTask> listOpenByWorkflowAndOwnerAndRequestId(final int workflowId, final int ownerId, final int requestId);
	List<GroupTask> listByOwnerAndRequestId(final int ownerId, final int requestId);
	List<GroupTask> listAllGroupTasks();
	List<GroupTask> listAllOpenGroupTasks();
}
